/*
 * Decompiled with CFR 0.152.
 */
package com.endilcrafter.farmersplus.common.block.entity;

import com.endilcrafter.farmersplus.common.crafting.DryingRackRecipe;
import com.endilcrafter.farmersplus.common.registry.PlusBlockEntities;
import com.endilcrafter.farmersplus.common.registry.PlusRecipeTypes;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class DryingRackBlockEntity
extends BlockEntity {
    private static final int INVENTORY_SLOT_COUNT = 4;
    private final ItemStackHandler inventory = this.createHandler();
    private final int[] dryingTimes = new int[4];
    private final int[] dryingTimesTotal = new int[4];
    private final ResourceLocation[] lastRecipeIDs = new ResourceLocation[4];

    public DryingRackBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)PlusBlockEntities.DRYING_RACK.get(), pPos, pBlockState);
    }

    public static void dryingTick(Level level, BlockPos pos, BlockState state, DryingRackBlockEntity rack) {
        rack.dryAndOutputItems();
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, DryingRackBlockEntity rack) {
    }

    public void m_142466_(CompoundTag compound) {
        int[] arrayDryingTimesTotal;
        super.m_142466_(compound);
        if (compound.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        } else {
            this.inventory.deserializeNBT(compound);
        }
        if (compound.m_128425_("DryingTimes", 11)) {
            arrayDryingTimesTotal = compound.m_128465_("DryingTimes");
            System.arraycopy(arrayDryingTimesTotal, 0, this.dryingTimes, 0, Math.min(this.dryingTimesTotal.length, arrayDryingTimesTotal.length));
        }
        if (compound.m_128425_("DryingTotalTimes", 11)) {
            arrayDryingTimesTotal = compound.m_128465_("DryingTotalTimes");
            System.arraycopy(arrayDryingTimesTotal, 0, this.dryingTimesTotal, 0, Math.min(this.dryingTimesTotal.length, arrayDryingTimesTotal.length));
        }
    }

    public void m_183515_(CompoundTag compound) {
        this.writeItems(compound);
        compound.m_128385_("DryingTimes", this.dryingTimes);
        compound.m_128385_("DryingTotalTimes", this.dryingTimesTotal);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    private void dryAndOutputItems() {
        if (this.f_58857_ == null) {
            return;
        }
        boolean didInventoryChange = false;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack resultStack;
            ItemStack rackStack = this.inventory.getStackInSlot(i);
            if (rackStack.m_41619_()) continue;
            int n = i;
            this.dryingTimes[n] = this.dryingTimes[n] + 1;
            if (this.dryingTimes[i] < this.dryingTimesTotal[i]) continue;
            SimpleContainer inventoryWrapper = new SimpleContainer(new ItemStack[]{rackStack});
            Optional<DryingRackRecipe> recipe = this.getMatchingRecipe((Container)inventoryWrapper, i);
            if (recipe.isPresent() && !(resultStack = recipe.get().m_8043_(this.f_58857_.m_9598_())).m_41619_()) {
                ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)resultStack.m_41777_(), (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 1.0), (double)((double)this.f_58858_.m_123343_() + 0.5), (double)(this.f_58857_.f_46441_.m_188583_() * (double)0.01f), (double)0.1f, (double)(this.f_58857_.f_46441_.m_188583_() * (double)0.01f));
            }
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
            didInventoryChange = true;
        }
        if (didInventoryChange) {
            this.inventoryChanged();
        }
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (!slotStack.m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public boolean addItem(ItemStack itemStackIn, DryingRackRecipe recipe, int slot) {
        ItemStack slotStack;
        if (0 <= slot && slot < this.inventory.getSlots() && (slotStack = this.inventory.getStackInSlot(slot)).m_41619_()) {
            this.dryingTimesTotal[slot] = recipe.getDryingTime();
            this.dryingTimes[slot] = 0;
            this.inventory.setStackInSlot(slot, itemStackIn.m_41620_(1));
            this.lastRecipeIDs[slot] = recipe.m_6423_();
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public Optional<DryingRackRecipe> getMatchingRecipe(Container recipeWrapper, int slot) {
        Recipe recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeIDs[slot] != null && (recipe = (Recipe)((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap((RecipeType)PlusRecipeTypes.DRYING.get()).get(this.lastRecipeIDs[slot])) instanceof DryingRackRecipe && recipe.m_5818_(recipeWrapper, this.f_58857_)) {
            return Optional.of((DryingRackRecipe)recipe);
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)PlusRecipeTypes.DRYING.get(), recipeWrapper, this.f_58857_);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Vec2 getRackItemOffset(int index) {
        float X_OFFSET = 0.2f;
        float Y_OFFSET = 0.2f;
        Vec2[] OFFSETS = new Vec2[]{new Vec2(0.2f, 0.2f), new Vec2(-0.2f, 0.2f), new Vec2(0.2f, -0.2f), new Vec2(-0.2f, -0.2f)};
        return OFFSETS[index];
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(4){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    protected void inventoryChanged() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }
}

